#include <stdio.h>
#include <hal_resources_defines_netx51.h>
#include <libc_file_support.h>
#include <libc_mem_support.h>

#include <ToolkitSample.h>

#define SERDPM_CONN  2 /* SPI on DPM interface */

int main()
{
  #if SERDPM_CONN == 0 /* X5 */
    NX51_MMIO_SetCfg(0, NX51_MMIO_CONFIG_SPI1_MOSI, 0, 0);
    NX51_MMIO_SetCfg(1, NX51_MMIO_CONFIG_SPI1_MISO, 0, 0);
    NX51_MMIO_SetCfg(2, NX51_MMIO_CONFIG_SPI1_CLK,  0, 0);
    NX51_MMIO_SetCfg(3, NX51_MMIO_CONFIG_SPI1_CS1N, 0, 0);
    NX51_MMIO_SetCfg(4, NX51_MMIO_CONFIG_PIO_MODE, 0, 0);
    NX51_MMIO_SetCfg(6, NX51_MMIO_CONFIG_PIO_MODE, 0, 0);
    NX51_MMIO_SetCfg(5, NX51_MMIO_CONFIG_PIO_MODE, 0, 0);
    NX51_MMIO_SetCfg(7, NX51_MMIO_CONFIG_PIO_MODE, 0, 0);
    NX51_MMIO_SetCfg(29,NX51_MMIO_CONFIG_PIO_MODE, 0, 0);
    NX51_MMIO_SetCfg(31,NX51_MMIO_CONFIG_SPI1_CS1N, 0, 0);
    NX51_MMIO_SetCfg(40,NX51_MMIO_CONFIG_PIO_MODE, 0, 0 );
    NX51_MMIO_SetCfg(41,NX51_MMIO_CONFIG_PIO_MODE, 0, 0 );
    NX51_MMIO_SetCfg(42,NX51_MMIO_CONFIG_PIO_MODE, 0, 0 );
    NX51_MMIO_SetCfg(43,NX51_MMIO_CONFIG_PIO_MODE, 0, 0 );
  #elif SERDPM_CONN == 1 /* X6 */
    NX51_MMIO_SetCfg(0, NX51_MMIO_CONFIG_PIO_MODE, 0, 0);
    NX51_MMIO_SetCfg(1, NX51_MMIO_CONFIG_PIO_MODE, 0, 0);
    NX51_MMIO_SetCfg(2, NX51_MMIO_CONFIG_PIO_MODE, 0, 0);
    NX51_MMIO_SetCfg(3, NX51_MMIO_CONFIG_PIO_MODE, 0, 0);
    NX51_MMIO_SetCfg(4, NX51_MMIO_CONFIG_SPI1_MISO, 0, 0);
    NX51_MMIO_SetCfg(6, NX51_MMIO_CONFIG_SPI1_MOSI, 0, 0);
    NX51_MMIO_SetCfg(5, NX51_MMIO_CONFIG_SPI1_CLK,  0, 0);
    NX51_MMIO_SetCfg(7, NX51_MMIO_CONFIG_SPI1_CS1N, 0, 0);
    NX51_MMIO_SetCfg(29,NX51_MMIO_CONFIG_SPI1_CS1N, 0, 0);
    NX51_MMIO_SetCfg(31,NX51_MMIO_CONFIG_PIO_MODE, 0, 0);
    NX51_MMIO_SetCfg(40,NX51_MMIO_CONFIG_PIO_MODE, 0, 0 );
    NX51_MMIO_SetCfg(41,NX51_MMIO_CONFIG_PIO_MODE, 0, 0 );
    NX51_MMIO_SetCfg(42,NX51_MMIO_CONFIG_PIO_MODE, 0, 0 );
    NX51_MMIO_SetCfg(43,NX51_MMIO_CONFIG_PIO_MODE, 0, 0 );
  #elif SERDPM_CONN == 2 /* spi on DPM interface */
    NX51_MMIO_SetCfg(0, NX51_MMIO_CONFIG_PIO_MODE, 0, 0);
    NX51_MMIO_SetCfg(1, NX51_MMIO_CONFIG_PIO_MODE, 0, 0);
    NX51_MMIO_SetCfg(2, NX51_MMIO_CONFIG_PIO_MODE, 0, 0);
    NX51_MMIO_SetCfg(3, NX51_MMIO_CONFIG_PIO_MODE, 0, 0);
    NX51_MMIO_SetCfg(4, NX51_MMIO_CONFIG_PIO_MODE, 0, 0);
    NX51_MMIO_SetCfg(6, NX51_MMIO_CONFIG_PIO_MODE, 0, 0);
    NX51_MMIO_SetCfg(5, NX51_MMIO_CONFIG_PIO_MODE, 0, 0);
    NX51_MMIO_SetCfg(7, NX51_MMIO_CONFIG_PIO_MODE, 0, 0);
    NX51_MMIO_SetCfg(40,NX51_MMIO_CONFIG_SPI1_MISO,0, 0 );
    NX51_MMIO_SetCfg(41,NX51_MMIO_CONFIG_SPI1_MOSI,0, 0 );
    NX51_MMIO_SetCfg(42,NX51_MMIO_CONFIG_SPI1_CS1N,0, 0 );
    NX51_MMIO_SetCfg(43,NX51_MMIO_CONFIG_SPI1_CLK, 0, 0 );
  #endif
  
  NX51_MMIO_SetCfg(34, NX51_MMIO_CONFIG_UART0_RXD, 0, 0);
  NX51_MMIO_SetCfg(35, NX51_MMIO_CONFIG_UART0_TXD, 0, 0);
  
  /* Disable hif to allow routing of spi1 to mmio 40-43 (SERDPM_CONN == 2) */
  NX51_HIF_IOCTRL_DeInit();
  
  /* Libc memory initialiation */
  libc_mem_init();
  
  /* Init the libc part & redirect printf output to uart */
  libc_file_init();

  ToolkitSample();

  while (1);
}
